
### Voorbeeld converteren naar PDF/A

Voorbeeld webpagina met levensloopdossier in HTML converteren naar PDF/A met [Gotenberg](https://gotenberg.dev/).

## Docker Compose
``` bash
./up.sh

./down.sh
```

### Gotenberg aanroepen in WebClient, Postman, enz

``` bash
HTTP POST http://localhost:3000/forms/chromium/convert/url
Content-Type: application/x-www-form-urlencoded

url=http://web-server:80/voorbeelddossier.html
pdfa=PDF/A-1b
```

![Voorbeeld Postman](voorbeeld_postman.png)


### Gotenberg aanroepen in Java

``` java
@RestController
@RequestMapping("/api/pdf")
public class PDFController {

    private final WebClient webClient;

    public PDFController(WebClient.Builder webClientBuilder) {
        this.webClient = webClientBuilder.baseUrl("http://pdf-server:3000").build();
    }

    @GetMapping("/genereer_pdf")
    public ResponseEntity<byte[]> generatePdf() {

        // Webpagina met levensloopdossier ophalen
        String url = "http://web-server:80/voorbeelddossier.html";
        String htmlContent = webClient.get()
                .uri(url)
                .retrieve()
                .bodyToMono(String.class)
                .block();

        MultiValueMap<String, HttpEntity<?>> body = new LinkedMultiValueMap<>();
        body.add("files", new ByteArrayResource(htmlContent.getBytes()) {
            @Override
            public String getFilename() {
                return "voorbeelddossier.html";
            }
        });

        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.MULTIPART_FORM_DATA);
        HttpEntity<MultiValueMap<String, HttpEntity<?>>> requestEntity = new HttpEntity<>(body, headers);

        // Conversie naar PDF/A met Gotenberg-container
        ResponseEntity<byte[]> response = webClient.post()
                .uri("/forms/chromium/convert/html")
                .header(HttpHeaders.CONTENT_TYPE, "multipart/form-data")
                .body(BodyInserters.fromMultipartData(body))
                .retrieve()
                .toEntity(byte[].class)
                .block();

        // Patiëntdossier als PDF-bytes teruggeven
        return ResponseEntity.ok()
                .header(HttpHeaders.CONTENT_DISPOSITION, "attachment; filename=voorbeelddossier.pdf")
                .contentType(MediaType.APPLICATION_PDF)
                .body(response.getBody());
    }
}
```
