﻿using Hl7.Fhir.Model;
using Task = System.Threading.Tasks.Task;

namespace Compare.Client;

internal class FhirTest(List<FhirSession> sessions)
{
    public List<FhirSession> Sessions { get; set; } = sessions;


    public async Task RunAsync(FhirQueryConfig query)
    {
        foreach (var session in Sessions)
        {
            if (!session.IsAvailable) continue;
            try
            {
                var bundleNext = await session.Client?.GetAsync(query.QueryUrl) as Bundle; //$"{session.Server.BaseUrl}{query.QueryUrl}" // &_total=accurate
                Bundle? bundle = bundleNext;

                while (bundleNext?.NextLink != null)
                {
                    bundleNext = await session.Client?.ContinueAsync(bundleNext);
                    if (bundleNext?.Entry != null)
                    {
                        bundle.Entry.AddRange(bundleNext.Entry);
                    }
                }
                session.ErrorMessage = string.Empty;

                switch (query.Name)
                {
                    // Operation $everything
                    case nameof(FhirQuery.Test1_PatientEverything):
                        session.TestResults1 = bundle;
                        break;

                    case nameof(FhirQuery.Test2_PatientEverythingWithPagination):
                        session.TestResults2 = bundle;
                        break;

                    case nameof(FhirQuery.Test3_PatientIdEverything):
                        session.TestResults3 = bundle;
                        break;

                    case nameof(FhirQuery.Test4_PatientIdEverythingWithPagination):
                        session.TestResults4 = bundle;
                        break;

                    // Operation $export
                    case nameof(FhirQuery.Test5_PatientExport):
                        session.TestResults5 = bundle;
                        break;

                    case nameof(FhirQuery.Test6_PatientIdExport):
                        session.TestResults6 = bundle;
                        break;

                    // Operation $document
                    case nameof(FhirQuery.Test7_PatientDocument):
                        session.TestResults7 = bundle;
                        break;

                    case nameof(FhirQuery.Test8_PatientIdDocument):
                        session.TestResults8 = bundle;
                        break;

                    // Operation $everything?_include=*
                    case nameof(FhirQuery.Test9_PatientIdEverythingWithInclude):
                        session.TestResults9 = bundle;
                        break;

                    case nameof(FhirQuery.Test10_PatientIdEverythingWithIncludes):
                        session.TestResults10 = bundle;
                        break;

                    case nameof(FhirQuery.Test11_PatientIdEverythingWithIncludeWildcard):
                        session.TestResults11 = bundle;
                        break;

                    // Operation $everything?_type=*
                    case nameof(FhirQuery.Test12_PatientIdEverythingWithType):
                        session.TestResults12 = bundle;
                        break;

                    default:
                        Console.WriteLine($" - Error {query.Name}: {query.Name} not found");
                        break;
                }
            }
            catch (Exception e)
            {
                session.ErrorMessage = e.Message;
                // Console.WriteLine($" - Error {query.Name}: {e.Message}");
            }
        }
        
    }

}
