/* Example verifying PDF/A conformance.
 * java Conformance.java
 * 
 * No XMP metadata found. This is not a PDF/A document.
 * 
 * Metadata publishes conformance to PDF/A.
 * Part: 1
 * Conformance: B
 */
import java.io.*;
import java.nio.charset.StandardCharsets;
import java.util.regex.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.InputSource;

public class Conformance {
    public static void main(String[] args) throws Exception {
        String pdfPath = "voorbeelddossier-met-pdfa.pdf";
        String xmp = extractXMPMetadata(pdfPath);

        if (xmp != null && !xmp.isEmpty()) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new InputSource(new StringReader(xmp)));

            Node partNode = doc.getElementsByTagNameNS("*", "part").item(0);
            Node confNode = doc.getElementsByTagNameNS("*", "conformance").item(0);

            if (partNode != null && confNode != null) {
                System.out.println("Metadata publishes conformance to PDF/A.");
                System.out.println("Part: " + partNode.getTextContent());
                System.out.println("Conformance: " + confNode.getTextContent());
            } else {
                System.out.println("No PDF/A metadata found.");
            }
        } else {
            System.out.println("No XMP metadata found. This is not a PDF/A document.");
        }
    }

    private static String extractXMPMetadata(String filePath) throws IOException {
        byte[] fileBytes = java.nio.file.Files.readAllBytes(new File(filePath).toPath());
        String content = new String(fileBytes, StandardCharsets.ISO_8859_1);
        
        Pattern pattern = Pattern.compile("(?s)<\\?xpacket begin=[^>]*?\\?>(.*?)<\\?xpacket end=[^>]*?\\?>");
        Matcher matcher = pattern.matcher(content);

        if (matcher.find()) {
            return matcher.group(1).trim();
        }

        return null;
    }
}
