## Testdataset 

Voorbeeldtestdata bij Overstapservice PGO-leverancier op PGO-koppelvlak.


### resources

Map resources bevat een kopie van [BgZ 3.0 testscripts](https://github.com/Nictiz/Nictiz-testscripts/tree/main/output/STU3/BgZ-3-0/MedMij/Test/\_reference/resources) gepubliceerd door Nictiz. Deelnemende ontwikkelpartners (POP's) geven er de voorkeur aan om de voorbeelden en structure definitions met deze profielen voor gegevensdienst Basisgegevensset zorg te gebruiken tijdens de fase geïsoleerd testen. De informatie komt uiteindelijk terug als een levensloopdossier in PDF/A-formaat.

```
resources/xml
resources/json
```

Resources zijn beschikbaar als XML en JSON. Nictiz gebruikt in testscripts lichte templating voor datums, daar is in deze set een invulling voor. De set geeft een voorbeeldinvulling waarmee POP's kunnen werken, de exacte content is minder relevant voor project PGO-koppelvlak omdat we niet kwalificeren op de inhoud van gegenereerde PDF/A-documenten. Heeft Interoplab of een PGO al een BgZ-testset geladen, dan voldoet dat.

### scenarios

Voor de usecase `Overstapservice PGO-leverancier` over PGO-koppelvlak hebben we twee resources DocumentReference op `Patient/medmij-bgz-patient-ts-01` (XXX_Helleman) bij de BgZ-testset:

1. medmij-portabiliteit-documentreference-1 (Portabiliteitsrapport in XML)
2. medmij-portabiliteit-documentreference-2 (Persoonlijk gezondheidsdossier in PDF/A)


### valuesets

In de usecase gebruiken we het veld `.class` (STU3) of `.category` (R4) op DocumentReference om aan te geven dat het gaat op portabiliteitsdocumenten die relevant zijn in de context van `Overstapservice PGO-leverancier`. Hiervoor hebben we een waardecodelijst (valueset):

- medmij-portabiliteit-codelijst.json 

Op veld `.type` is er daarnaast een code uit dezelfde codelijst mogelijk die aangeeft of het hier gaat om portabiliteitsrapport in XML, persoonlijk gezondheidsdossier in PDF/A of een bijlage op het levensloopdossier.

Verzamelen Documenten 3.0 (PDF/A 3.0) specificeert het gebruik van Minimal.DocumentReference. om vast te leggen dat de waardecodelijst gebruikt wordt voor de twee velden hebben wij daarbij een profiel gemaakt Minimal.DocumentReference.MedMijPortabiliteit.

- medmij-portabiliteit-documentreference-structuredefinition.json

Voor nu een concept dat we graag doornemen met ontwikkelpartners.


### Voorbeeld:

```
GET http://localhost:8080/fhir/DocumentReference?class=urn:oid:2.16.528.1.1023.11.2.3.11.10|EXPORT
GET http://localhost:8080/hapi-fhir-jpaserver/fhir/DocumentReference?subject=Patient/medmij-bgz-test-patA&class=urn%3Aoid%3A2.16.528.1.1023.11.2.3.11.10%7CEXPORT
```