﻿namespace Compare.Client;

internal static class FhirQuery
{
    // Operation $everything
    public static readonly FhirQueryConfig Test1_PatientEverything = new()
    {
        Id = 1,
        Name = nameof(Test1_PatientEverything),
        ShortName = "$everything",
        QueryUrl = "Patient/$everything"
    };

    public static readonly FhirQueryConfig Test2_PatientEverythingWithPagination = new()
    {
        Id = 2,
        Name = nameof(Test2_PatientEverythingWithPagination),
        ShortName = "$everything _count",
        QueryUrl = "Patient/$everything?_count=1"
    };

    public static readonly FhirQueryConfig Test3_PatientIdEverything = new()
    {
        Id = 3,
        Name = nameof(Test3_PatientIdEverything),
        ShortName = "$everything id",
        QueryUrl = "Patient/nl-core-Patient-01/$everything"
    };

    public static readonly FhirQueryConfig Test4_PatientIdEverythingWithPagination = new()
    {
        Id = 4,
        Name = nameof(Test4_PatientIdEverythingWithPagination),
        ShortName = "$everything id _count",
        QueryUrl = "Patient/nl-core-Patient-01/$everything?_count=1"
    };

    // Operation $everything
    public static readonly FhirQueryConfig Test5_PatientExport = new()
    {
        Id = 5,
        Name = nameof(Test5_PatientExport),
        ShortName = "$export",
        QueryUrl = "Patient/$export"
    };

    public static readonly FhirQueryConfig Test6_PatientIdExport = new()
    {
        Id = 6,
        Name = nameof(Test6_PatientIdExport),
        ShortName = "$export id",
        QueryUrl = "Patient/nl-core-Patient-01/$export"
    };

    // Operation $document
    public static readonly FhirQueryConfig Test7_PatientDocument = new()
    {
        Id = 7,
        Name = nameof(Test7_PatientDocument),
        ShortName = "$document",
        QueryUrl = "Patient/$document"
    };

    public static readonly FhirQueryConfig Test8_PatientIdDocument = new()
    {
        Id = 8,
        Name = nameof(Test8_PatientIdDocument),
        ShortName = "$document id",
        QueryUrl = "Patient/nl-core-Patient-01/$document"
    };

    public static readonly FhirQueryConfig Test9_PatientIdEverythingWithInclude = new()
    {
        Id = 9,
        Name = nameof(Test9_PatientIdEverythingWithInclude),
        ShortName = "$everything id _include",
        QueryUrl = "Patient/nl-core-Patient-01/$everything?_include=Account,AdverseEvent,AllergyIntolerance,Appointment,AppointmentResponse,AuditEvent,Basic,BiologicallyDerivedProductDispense,BodyStructure,CarePlan,CareTeam,ChargeItem,Claim,ClaimResponse,ClinicalImpression,Communication,CommunicationRequest,Composition,Condition,Consent,Contract,Coverage,CoverageEligibilityRequest,CoverageEligibilityResponse,DetectedIssue,DeviceAssociation,DeviceRequest,DeviceUsage,DiagnosticReport,DocumentReference,Encounter,EncounterHistory,EnrollmentRequest,EpisodeOfCare,ExplanationOfBenefit,FamilyMemberHistory,Flag,GenomicStudy,Goal,Group,GuidanceResponse,ImagingSelection,ImagingStudy,Immunization,ImmunizationEvaluation,ImmunizationRecommendation,Invoice,List,MeasureReport,MedicationAdministration,MedicationDispense,MedicationRequest,MedicationStatement,MolecularSequence,NutritionIntake,NutritionOrder,Observation,Patient,Person,Procedure,Provenance,QuestionnaireResponse,RelatedPerson,RequestOrchestration,ResearchSubject,RiskAssessment,Schedule,ServiceRequest,Specimen,SupplyDelivery,SupplyRequest,Task,VisionPrescription"
    };

    public static readonly FhirQueryConfig Test10_PatientIdEverythingWithIncludes = new()
    {
        Id = 10,
        Name = nameof(Test10_PatientIdEverythingWithIncludes),
        ShortName = "$everything id _includes",
        QueryUrl = "Patient/nl-core-Patient-01/$everything?_include=Account:subject,_include=AdverseEvent:subject,_include=AllergyIntolerance:patient,_include=AllergyIntolerance:participant,_include=Appointment:actor,_include=AppointmentResponse:actor,_include=AuditEvent:patient,_include=Basic:patient,_include=Basic:author,_include=BiologicallyDerivedProductDispense:patient,_include=BodyStructure:patient,_include=CarePlan:patient,_include=CareTeam:patient,_include=CareTeam:participant,_include=ChargeItem:subject,_include=Claim:patient,_include=Claim:payee,_include=ClaimResponse:patient,_include=ClinicalImpression:subject,_include=Communication:subject,_include=Communication:sender,_include=Communication:recipient,_include=CommunicationRequest:subject,_include=CommunicationRequest:information-provider,_include=CommunicationRequest:recipient,_include=CommunicationRequest:requester,_include=Composition:subject,_include=Composition:author,_include=Composition:attester,_include=Condition:patient,_include=Condition:participant-actor,_include=Consent:subject,_include=Contract:patient,_include=Coverage:policy-holder,_include=Coverage:subscriber,_include=Coverage:beneficiary,_include=Coverage:paymentby-party,_include=CoverageEligibilityRequest:patient,_include=CoverageEligibilityResponse:patient,_include=DetectedIssue:patient,_include=DeviceAssociation:subject,_include=DeviceAssociation:operator,_include=DeviceRequest:subject,_include=DeviceRequest:performer,_include=DeviceUsage:patient,_include=DiagnosticReport:subject,_include=DocumentReference:subject,_include=DocumentReference:author,_include=Encounter:patient,_include=EncounterHistory:patient,_include=EnrollmentRequest:subject,_include=EpisodeOfCare:patient,_include=ExplanationOfBenefit:patient,_include=ExplanationOfBenefit:payee,_include=FamilyMemberHistory:patient,_include=Flag:patient,_include=GenomicStudy:patient,_include=Goal:patient,_include=Group:member,_include=GuidanceResponse:patient,_include=ImagingSelection:patient,_include=ImagingStudy:patient,_include=Immunization:patient,_include=ImmunizationEvaluation:patient,_include=ImmunizationRecommendation:patient,_include=Invoice:subject,_include=Invoice:patient,_include=Invoice:recipient,_include=List:subject,_include=List:source,_include=MeasureReport:patient,_include=MedicationAdministration:patient,_include=MedicationAdministration:subject,_include=MedicationDispense:subject,_include=MedicationDispense:patient,_include=MedicationDispense:receiver,_include=MedicationRequest:subject,_include=MedicationStatement:subject,_include=MolecularSequence:subject,_include=NutritionIntake:subject,_include=NutritionIntake:source,_include=NutritionOrder:patient,_include=Observation:subject,_include=Observation:performer,_include=Patient:link,_include=Person:patient,_include=Procedure:patient,_include=Procedure:performer,_include=Provenance:patient,_include=QuestionnaireResponse:subject,_include=QuestionnaireResponse:author,_include=RelatedPerson:patient,_include=RequestOrchestration:subject,_include=RequestOrchestration:participant,_include=ResearchSubject:subject,_include=RiskAssessment:subject,_include=Schedule:actor,_include=ServiceRequest:subject,_include=ServiceRequest:performer,_include=Specimen:subject,_include=SupplyDelivery:patient,_include=SupplyRequest:subject,_include=Task:patient,_include=Task:focus,_include=VisionPrescription:patient"
    };

    public static readonly FhirQueryConfig Test11_PatientIdEverythingWithIncludeWildcard = new()
    {
        Id = 11,
        Name = nameof(Test11_PatientIdEverythingWithIncludeWildcard),
        ShortName = "$everything id _include=*",
        QueryUrl = "Patient/nl-core-Patient-01/$everything?_include=*"
    };

    public static readonly FhirQueryConfig Test12_PatientIdEverythingWithType = new()
    {
        Id = 12,
        Name = nameof(Test12_PatientIdEverythingWithType), 
        ShortName = "$everything id _type", // Microsoft Azure FHIR Server ?_type = https://learn.microsoft.com/en-us/azure/healthcare-apis/fhir/patient-everything#patient-everything-parameters
        QueryUrl = "Patient/nl-core-Patient-01/$everything?_type=Account,AdverseEvent,AllergyIntolerance,Appointment,AppointmentResponse,AuditEvent,Basic,BiologicallyDerivedProductDispense,BodyStructure,CarePlan,CareTeam,ChargeItem,Claim,ClaimResponse,ClinicalImpression,Communication,CommunicationRequest,Composition,Condition,Consent,Contract,Coverage,CoverageEligibilityRequest,CoverageEligibilityResponse,DetectedIssue,DeviceAssociation,DeviceRequest,DeviceUsage,DiagnosticReport,DocumentReference,Encounter,EncounterHistory,EnrollmentRequest,EpisodeOfCare,ExplanationOfBenefit,FamilyMemberHistory,Flag,GenomicStudy,Goal,Group,GuidanceResponse,ImagingSelection,ImagingStudy,Immunization,ImmunizationEvaluation,ImmunizationRecommendation,Invoice,List,MeasureReport,MedicationAdministration,MedicationDispense,MedicationRequest,MedicationStatement,MolecularSequence,NutritionIntake,NutritionOrder,Observation,Patient,Person,Procedure,Provenance,QuestionnaireResponse,RelatedPerson,RequestOrchestration,ResearchSubject,RiskAssessment,Schedule,ServiceRequest,Specimen,SupplyDelivery,SupplyRequest,Task,VisionPrescription"
    };
}




internal class FhirQueryConfig
{
    public int Id { get; set; }
    public string Name { get; set; }
    public string ShortName { get; set; }
    public string QueryUrl { get; set; }
    public object Parameters { get; set; }
}